import { type ClientSchema, a, defineData, defineFunction } from "@aws-amplify/backend"
import { env } from "../env.setup"
import { listAllUsers } from "./list-all-users/resource";
import { inviteUser } from "./invite-user/resource";
import { deleteUser } from "./delete-user/resource";
import { triggerPublishPreviewToLive } from "./trigger-publish-preview-to-live/resource";

export const INTERNAL__StatewideServicesKey = "StatewideServices" as const
export const INTERNAL__UserMetadataKey = "UsersMetadata" as const
const INTERNAL__userMetadataIdKey = "userid" as const

export const startOtpDataUpdate = defineFunction({
  name: 'start-otp-data-update',
  entry: './start-otp-data-update/handler.ts',
  environment: {
    BACKEND_AWS_STEP_FUNCTION_ARN: env.BACKEND_AWS_STEP_FUNCTION_ARN
  },
});

const schema = a.schema({
  triggerPublishPreviewToLive: a
    .query()
    .returns(a.json())
    .authorization(allow => [allow.group(env.BACKEND_AWS_COGNITO_ADMIN_GROUP_NAME)])
    .handler(a.handler.function(triggerPublishPreviewToLive)),

  startOtpDataUpdate: a
    .query()
    .arguments({
      agencyid: a.string().required(),
    })
    .returns(a.json())
    .authorization(allow => [allow.group(env.BACKEND_AWS_COGNITO_ADMIN_GROUP_NAME)])
    .handler(a.handler.function(startOtpDataUpdate)),

  [INTERNAL__StatewideServicesKey]: a.model({
    agencyid: a.string().required(),
    phone: a.phone(),
    url: a.url(),
    message: a.string().required(),
    alias: a.string().required(),
    status: a.enum(['UNKNOWN', 'PENDING_APPROVAL', 'PUBLISHED']),
  })
    .authorization(allow => [allow.group(env.BACKEND_AWS_COGNITO_ADMIN_GROUP_NAME)])
  ,

  [INTERNAL__UserMetadataKey]: a.model({
    [INTERNAL__userMetadataIdKey]: a.id().required(),
    agencyid: a.string().required(),
  })
    .identifier([INTERNAL__userMetadataIdKey])
    .authorization(allow => [allow.group(env.BACKEND_AWS_COGNITO_ADMIN_GROUP_NAME)])
  ,

  listAllUsers: a
    .query()
    .authorization((allow) => [allow.group(env.BACKEND_AWS_COGNITO_ADMIN_GROUP_NAME)])
    .handler(a.handler.function(listAllUsers))
    .returns(a.json()),

  inviteNewUser: a
    .mutation()
    .arguments({
      email: a.string().required(),
      agencyid: a.string().required(),
      groupName: a.enum([env.BACKEND_AWS_COGNITO_ADMIN_GROUP_NAME, env.BACKEND_AWS_COGNITO_VIEWER_GROUP_NAME]),
    })
    .authorization((allow) => [allow.group(env.BACKEND_AWS_COGNITO_ADMIN_GROUP_NAME)])
    .handler(a.handler.function(inviteUser))
    .returns(a.json()),

  deleteUser: a
    .mutation()
    .arguments({
      email: a.string().required(),
    })
    .authorization((allow) => [allow.group(env.BACKEND_AWS_COGNITO_ADMIN_GROUP_NAME)])
    .handler(a.handler.function(deleteUser))
    .returns(a.json()),
})

export type Schema = ClientSchema<typeof schema>

export const data = defineData({
  name: `${env.BACKEND_AWS_COGNITO_RESOURCE_NAME_PREFIX}AmplifyGraphQlAppSync`,
  schema,
})
